#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# install_os2.pl
#---------------------------------------------------------------------

# $Log: install_os2.pl,v $
# Revision 1.4  1998/09/06 11:10:11  reinhold
# Versionsnummer auf 1.29 geaendert,
#
# Revision 1.3  1998/04/10 15:16:04  kalli
# Rev. 1.28
#
# Revision 1.2  1998/03/27 20:40:23  kalli
# Browser wird in newtonlink.config gepatcht
#
# Revision 1.1  1998/03/12 20:46:55  kalli
# Initial revision
#

# actual Newtonlink version number to install 
$version = "1.29";



#---------------------------------------------------------------------
# SetDefaults - Set some default values
#---------------------------------------------------------------------

sub SetDefaults {

    $PERL_EXE    = "e:/emx/bin/perl.exe";
    $BROWSER_EXE = "netscape";
    $PID_DIR     = "d:/tmp";
    $SER_DEV     = "COM1";
    $LIB_DIR     = ".";
    $CFG_DIR     = ".";
}




#---------------------------------------------------------------------
# PrintInstallValues - Print choosen values
#---------------------------------------------------------------------

sub PrintInstallValues {

    print "Your Perl5 executable :                     $PERL_EXE\n";
    print "Your HTML browser :                         $BROWSER_EXE\n";
    print "Directory for the Newtonlink PID file :     $PID_DIR\n";
    print "Serial Device :                             $SER_DEV\n";
}




#---------------------------------------------------------------------
# PatchFile_newtonlink_config - Patch variables into file
#---------------------------------------------------------------------

sub PatchFile_newtonlink_config {

    open (NLCFILE, "newtonlink.config")  || die "Can't open File : $!\n";
    # Open newtonlink sed file
    open (NLCSEDFILE, "> newtonlink.config.sed")  || die "Can't open File : $!\n";

    while (<NLCFILE>) {
	s/S_NEWTONLINK_PIDFILEDIR_S/$PID_DIR/g;
        s/S_NEWTONLINK_SYSMODE_S/OS-2/g;
	s/S_NEWTONLINK_BROWSER_S/$BROWSER_EXE/g;
        s/S_NEWTONLINK_SERDEV_S/$SER_DEV/g;
	print NLCSEDFILE $_;
    }     

    # close files
    close (NLCFILE);
    close (NLCSEDFILE);
	    
}




#---------------------------------------------------------------------
# PatchFile_newtonlink - Patch variables into file
#---------------------------------------------------------------------

sub PatchFile_newtonlink {

    open (NLFILE, "newtonlink")  || die "Can't open File : $!\n";
    # Open newtonlink sed file
    open (NLSEDFILE, "> newtonlink.sed")  || die "Can't open File : $!\n";

    while (<NLFILE>) {
        s/S_PERLBINARY_S/$PERL_EXE/g;
	s/S_NEWTONLINK_INSTALLDIR_S/$LIB_DIR/g;
	s/S_NEWTONLINK_CONFIGFILEDIR_S/$CFG_DIR/g;
	print NLSEDFILE $_;
    }     

    # close files
    close (NLFILE);
    close (NLSEDFILE);
	    
}



#---------------------------------------------------------------------
# FinalInstall - Final install procedure
#---------------------------------------------------------------------

sub FinalInstall {

    system "cmd /c attrib -r newtonlink";
    system "cmd /c del newtonlink";
    system "cmd /c move newtonlink.sed newtonlink";
    system "cmd /c attrib -r newtonlink.config";
    system "cmd /c del newtonlink.config";
    system "cmd /c move newtonlink.config.sed newtonlink.config";
}





#---------------------------------------------------------------------
# InstallNonLFS - Install Newtonlink interactive
#---------------------------------------------------------------------

sub InstallNonLFS {

    print "OK, so I have to ask you some questions :\n\n";
    $isok = "no";

    while ($isok eq "no") {
        
    	print "Path to your Perl5 executable [$PERL_EXE] : ";
    	$a = <STDIN>;
    	chop ($a);
    	if ($a ne "") {
	    $PERL_EXE = $a;
    	}

    	print "Your HTML browser [$BROWSER_EXE] : ";
    	$a = <STDIN>;
    	chop ($a);
    	if ($a ne "") {
	    $BROWSER_EXE = $a;
    	}

    	print "Directory for Newtonlid PID file [$PID_DIR] : ";
    	$a = <STDIN>;
    	chop ($a);
    	if ($a ne "") {
	    $PID_DIR = $a;
    	}

    	print "Serial Device to use for Communication[$SER_DEV] : COM";
    	$a = <STDIN>;
    	chop ($a);
    	if ($a ne "") {
	    $SER_DEV = "COM$a";
    	}
    
    	print "\nThis is your choosen configuration :\n";
	&PrintInstallValues;

    	while ( ($a ne "y") && ($a ne "n") && ($a ne "q") ) {
            print "Is this ok ? (y|n|q) ";
            $a = <STDIN>;
            chop ($a);
        }

    	if ($a eq "q") {
            print "Installation aborted\n";
            exit;
	} elsif ($a eq "n") {
	    $isok = "no";
	    print "\n";	    	    
        } else {
	    $isok = "yes";
            print "Starting configuration, please wait ...\n";

	    # patch informations into files
	    &PatchFile_newtonlink_config;
	    &PatchFile_newtonlink;
	    # install
	    &FinalInstall;   	    
        }
    }
}


print "\nWelcome to the Newtonlink install procedure\n\n";

# set some defaults
&SetDefaults;
&InstallNonLFS;
