#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# GetPrintOutbox
#---------------------------------------------------------------------

# $Log: GetPrintOutbox.pl,v $
# Revision 1.8  1998/03/22 19:46:35  kalli
# Previewer lt. Confogfile
#
# Revision 1.7  1998/03/07 13:08:19  kalli
# Umstellung auf neue ser. Treiber
#
# Revision 1.6  1997/12/06 17:25:48  kalli
# Umstellung auf Sloup
#
# Revision 1.5  1997/09/28 10:03:37  kalli
# Aenderung von Andrew :
# Select-Statement
#
# Revision 1.4  1997/03/27 19:44:27  kalli
# Andrew dazu
#
# Revision 1.3  1997/02/23 15:12:15  kalli
# Frank dazu
#
# Revision 1.2  1997/02/22 17:01:27  kalli
# GPL dazu
#
# Revision 1.1  1996/11/24 19:52:05  kalli
# Initial revision
#

sub GetPrintOutbox {

    # start counter
    $PrintCounter = 0;
    # set marker
    $PrintOn = "off";

    # save old printout file
    if (-e "$PrintFile") {
	rename ("$PrintFile", "$PrintFile.bak");
    }

    # Open file
    open  (PRFILE, ">> $PrintFile")  || die "Can't open File : $!\n";

    # send commands to Sloup
    &send_line (COMNEWTON, "\nOutbox\n");
    &send_line (COMNEWTON, '{state: "string", category: "string", title: "string", fromName: "string", toName: "string",' . 
                           'timestamp: "date", body: {title: "string", data: [{text: "string"}]}}');
    &send_line (COMNEWTON, "\nDUMP!\n");

    while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	# replace German Umlaute
        s/\232//g; s/\212//g; s/\237//g; s/\247//g; s/\205//g; s/\200//g; s/\206//g;
	# split into 
	($PRstate, $PRcategory, $PRconcern, $PRfromName, $PRtoName, $PRtimestamp, $PRbodytitle, $PRdata) = split(/\t/, $_, 10);

	# if new outbox entry
	if (defined ($PRstate) && ($PRstate eq "ready")) {

	    if (defined ($PRcategory) && ($PRcategory eq "print:newton")) {

		# set marker
		$PrintOn = "on";
		# print to file
		printf PRFILE "Concern : $PRconcern\n";
		printf PRFILE "Title   : $PRbodytitle\n";
		printf PRFILE "From    : $PRfromName\n";
		printf PRFILE "To      : $PRtoName\n";
		printf PRFILE "Time    : $PRtimestamp\n";
		printf PRFILE "\n$PRdata\n";

		# Print sign to stdout
		print "#";
		$PrintCounter++;
	
	    } else {
		# reset marker
		$PrintOn = "off";
	    }

	# if not new outbox entry
	} elsif ($PrintOn eq "on") {
	    print PRFILE "$_\n";
	}

    }

    # close file
    close (PRFILE);

    # print to stdout
    print ("\n$PrintCounter printouts transfered to $PrintFile");
  
    if ($PrintCounter > 0) {

        if ($SystemPrintCommand ne "") {

            printf "\nCreate postscript file $PrintFile.ps\n";
            # convert print file to postscript
            system "$SystemPrintCommand $PrintFile > $PrintFile.ps";

            # start previewer
            if ($PrintPreviewCommand ne "") {
	        printf "Starting previewer\n";
	        system "$PrintPreviewCommand $PrintFile.ps &";
            }
	}
    }
}

1;
