#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# GetPackageNames
#---------------------------------------------------------------------

# $Log: GetPackageNames.pl,v $
# Revision 1.8  1998/09/02 13:56:51  kalli
# *** empty log message ***
#
# Revision 1.7  1998/03/24 20:30:28  kalli
# Umstellung auf format-Anweisung
#
# Revision 1.6  1998/03/16 14:58:05  kalli
# Umstellung auf neue ser. Treiber mit Timeout.
#
# Revision 1.5  1998/03/06 23:13:17  kalli
# Umstellung auf neue ser. Treiber
#
# Revision 1.4  1997/12/06 17:23:46  kalli
# Umstellung auf Sloup
#
# Revision 1.3  1997/09/28 10:02:15  kalli
# Aenderung von Andrew :
# Select-Statement
#
# Revision 1.2  1997/03/27 19:42:23  kalli
# Andrew dazu
#
# Revision 1.1  1997/03/04 21:05:33  kalli
# Initial revision
#

format STDOUT = 
@<<<<<<<<<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<<<<<<<<<
$PackageNames[$niP]        $PackageNames[$niP+1]      $PackageNames[$niP+2]
.

sub GetPackageNames {

    select((select(STDOUT), $|=1)[$[]);

    # save old Newtonlink package names file
    if (-e "$NLPackageNamesFile") {
	rename ("$NLPackageNamesFile", "$NLPackageNamesFile.bak");
    }

    # Open file
    open (PACKAGENAMESFILE, ">> $NLPackageNamesFile")  || die "Can't open File : $!\n";

    printf "\nScanning for installed packages ...\n";

    # start counter
    $PackageCounter = 0;

    # send commands to Sloup
    &send_line (COMNEWTON, "\nPackage");
    &send_line (COMNEWTON, "{}"); 
    &send_line (COMNEWTON, "DUMP!");

    while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

         $PackageNames[$PackageCounter] = $_;
         printf PACKAGENAMESFILE "$PackageNames[$PackageCounter]\n";
	 $PackageCounter++;
	 print "#";
    }

    # print result to stdout
    print ("\n$PackageCounter package names transfered : \n");
    for ($niP = 0; $niP < $PackageCounter; $niP += 3) {
        write STDOUT;
    }

    # close file
    close (PACKAGENAMESFILE);

}


1;
