#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# GetNotes
#---------------------------------------------------------------------

# $Log: GetNotes.pl,v $
# Revision 1.2  1998/09/02 13:56:36  kalli
# *** empty log message ***
#
# Revision 1.1  1998/09/01 14:53:34  kalli
# Initial revision
#

sub GetNotes {
    
    if ($NotesAreActual ne "true") {

        select((select(STDOUT), $|=1)[$[]);

        # start counter
        $KjNotesCounter = 0;
        $KjPaperCounter = 0;
        $KjListCounter  = 0;
        $KjCheckCounter = 0;

        $NewEntry       = 1;

        $Underline = "-----------------------------------------------------------";

        # temporarily save Folder name
        $FolderName     = "";

        # save old Notes file
        if (-e "$NLNotesFile") {
	    rename ("$NLNotesFile", "$NLNotesFile.bak");
        }

        # Open new Notes file
        open (NOTESFILE, ">> $NLNotesFile")  || die "Can't open File : $NLNotesFile\n";

        # submit Notes separated as paperroll, list, checkList
        # first line is Folder name,
        # second line is title of note

        print ("\nScanning for paperroll entries ...\n");

        # send commands to Sloup
        &send_line (COMNEWTON, "\nNotes");
        &send_line (COMNEWTON, '{class: \'paperroll,labels: \'_all,title: \'String}'); 
        &send_line (COMNEWTON, "DUMP!");

        while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	    if ($_ ne "") {

	        # replace german Umlaute
	        s/\232//g; s/\212//g;
	        s/\237//g;s/\247//g;s/\205//g;s/\200//g; s/\206//g;
	        s/\\u00F6\\u//g;
                s// /g;

	        # Print sign to STDOUT
	        print "#";
	        $KjNotesCounter++;
                $KjPaperCounter++;

                if ($_ ne "-----") {

 	            # write to Notes file
 	            if (($NewEntry == 1) || ($NewEntry == 2)) {

                        if ($NewEntry == 1) {

                            $FolderName = $_;
                            chomp $FolderName;
                            $NewEntry = 2;

                        } else {

                            if ($NewEntry == 2) {
   	                        printf( NOTESFILE "\\NewEntry ");
                                printf( NOTESFILE $FolderName);
                                printf( NOTESFILE " / ");
	                        print NOTESFILE "$_\n";

                                # Make a Header
	                        print NOTESFILE "$_\n";
                                $LenOfTitle = length $_ ;
                                #if ($LenOfTitle > 0) {
                                #    $LenOfTitle--;
                                #}
                                $Underl = substr $Underline,0,$LenOfTitle;
                                printf (NOTESFILE $Underl);
                                printf (NOTESFILE "\n\n");
                                $NewEntry = 0;
                            }
 	                }
                    } else {

	                print NOTESFILE "$_\n";
                        $NewEntry = 0;
                    }

                } else {
                    $NewEntry = 1;
                }
	    }
        }

        # print to stdout
        print ("\n$KjPaperCounter lines of paperroll notes transfered");
        print ("\nNow scanning for list entries ...\n");

        # submit list entries

        # send commands to Sloup
        &send_line (COMNEWTON, "\nNotes");
        &send_line (COMNEWTON, '{class: \'list,labels: \'_all,title: \'String}'); 
        &send_line (COMNEWTON, "DUMP!");

        while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	    if ($_ ne "") {

	        # replace german Umlaute
	        s/\232//g; s/\212//g;
	        s/\237//g;s/\247//g;s/\205//g;s/\200//g; s/\206//g;
	        s/\\u00F6\\u//g; 
                s// /g;

	        # Print sign to STDOUT
	        print "#";
	        $KjNotesCounter++;
                $KjListCounter++;

                if ($_ ne "-----") {

 	           # write to Notes file
 	           if (($NewEntry == 1) || ($NewEntry == 2)) {
                       if ($NewEntry == 1) {

                            $FolderName = $_;
                            chomp $FolderName;
                            $NewEntry = 2;

                        } else {

                            if ($NewEntry == 2) {
   	                        printf( NOTESFILE "\\NewEntry ");
                                printf( NOTESFILE $FolderName);
                                printf( NOTESFILE " / ");
	                        print NOTESFILE "$_\n";

                                # Make a Header
	                        print NOTESFILE "$_\n";
                                $LenOfTitle = length $_ ;
                                #if ($LenOfTitle > 0) {
                                #    $LenOfTitle--;
                                #}
                                $Underl = substr $Underline,0,$LenOfTitle;
                                printf (NOTESFILE $Underl);
                                printf (NOTESFILE "\n\n");
                                $NewEntry = 0;
                            }
 	                }
                    } else {

	                print NOTESFILE "$_\n";
                        $NewEntry = 0;
                    }

                } else {
                    $NewEntry = 1;           
                }
	    }
        }

        # print to stdout
        print ("\n$KjListCounter lines of list notes transfered");
        print ("\nNow scanning for checklist entries ...\n");

        # submit checkList entries

        # send commands to Sloup
        &send_line (COMNEWTON, "\nNotes");
        &send_line (COMNEWTON, '{class: \'checkList,labels: \'_all,title: \'String}'); 
        &send_line (COMNEWTON, "DUMP!");

        while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	    if ($_ ne "") {

	        # replace german Umlaute
	        s/\232//g; s/\212//g;
	        s/\237//g;s/\247//g;s/\205//g;s/\200//g; s/\206//g;
	        s/\\u00F6\\u//g; 
                s// /g;

	        # Print sign to STDOUT
	        print "#";
	        $KjNotesCounter++;
                $KjCheckCounter++;

                if ($_ ne "-----") {

 	            # write to Notes file
 	            if (($NewEntry == 1) || ($NewEntry == 2)) {
                        if ($NewEntry == 1) {

                            $FolderName = $_;
                            chomp $FolderName;
                            $NewEntry = 2;

                        } else {

                            if ($NewEntry == 2) {
   	                        printf( NOTESFILE "\\NewEntry ");
                                printf( NOTESFILE $FolderName);
                                printf( NOTESFILE " / ");
	                        print NOTESFILE "$_\n";

                                # Make a Header
	                        print NOTESFILE "$_\n";
                                $LenOfTitle = length $_ ;
                                #if ($LenOfTitle > 0) {
                                #    $LenOfTitle--;
                                #}
                                $Underl = substr $Underline,0,$LenOfTitle;
                                printf (NOTESFILE $Underl);
                                printf (NOTESFILE "\n\n");
                                $NewEntry = 0;
                            }
 	                }
                    } else {

	                print NOTESFILE "$_\n";
                        $NewEntry = 0;
                    }

                } else {
                    $NewEntry = 1;
                }
	    }
        }

        # print to stdout
        print ("\n$KjCheckCounter lines of checklist notes transfered");
        print ("\n$KjNotesCounter lines of notes totally transfered");

        # close file
        close (NOTESFILE);

        # now read NOTESFILE, sort and output
        print ("\nNotes file will now be sorted ...\n");

        # Open new Notes file
        $KString = "";
        open (NOTESFILE, "$NLNotesFile")  || die "Can't open File : $NLNotesFile\n";

        while ($i = <NOTESFILE>) {
            $KString = $KString.$i;
        }
        close (NOTESFILE);

        @KList = split ("\NewEntry", $KString);
        @KList = sort (@KList);
        $KString = join ("\NewEntry", @KList);
        open (NOTESFILE, "> $NLNotesFile")  || die "Can't open File : $NLNotesFile\n";        
    
        printf (NOTESFILE "\\NewEntry");
        printf (NOTESFILE $KString);
    
        close (NOTESFILE);

        # mark notes file as actual
        $NotesAreActual = "true";

    }
}

1;



