#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# GetMeetings4Plan
#---------------------------------------------------------------------

# $Log: GetMeetings4Plan.pl,v $
# Revision 1.20  1998/03/07 16:35:10  kalli
# Umstellung auf neue ser. Treiber
#
# Revision 1.18  1998/01/11 16:46:50  kalli
# Erweiterungen von Gerald Hofer :
# Ersetzung der Umlaute bei IRIX
# Private Planfile
#
# Revision 1.16  1997/11/18 19:07:24  kalli
# Debugkommentare raus
#
# Revision 1.15  1997/11/15 20:17:26  kalli
# Bugfix : Repeat Meetings waren um einen Tag nach hinten verschoben.
#
# Revision 1.14  1997/11/15 19:18:18  kalli
# Convdate ersetzt durch Perl-Lib
#
# Revision 1.13  1997/09/05 20:01:42  kalli
# dos2unix darueber
#
# Revision 1.12  1997/09/05 19:38:23  kalli
# Erweiterungen von Andrew :
# Globale Optionen in .dayplan werden nicht ueberschrieben
#
# Revision 1.11  1997/05/31 09:49:12  kalli
# Unterscheidung limited/unlimited repeat meetings
#
# Revision 1.10  1997/05/28 19:25:35  kalli
# Aenderungen von Gerald Hofer fuer IRIX,
# Bugfixes
#
# Revision 1.8  1997/04/12 21:05:00  kalli
# Bugfixes :
# \n vor jedem Sloup-Kommando
# Repeat Meetings waren um einen Tag nach vorne verschoben
#
# Revision 1.7  1997/04/08 18:27:17  kalli
# Variables Datumsformat eingefuehrt : Andrew
# Bugfixes
#
# Revision 1.6  1997/03/27 19:39:46  kalli
# Andrew dazu
#
# Revision 1.5  1997/02/23 15:10:34  kalli
# Frank dazu
#
# Revision 1.4  1997/02/22 17:00:20  kalli
# GPL dazu
#
# Revision 1.3  1996/12/14 14:43:12  kalli
# Neu mit calendar notes, taeglich wiederholdende Termine
#
# Revision 1.2  1996/11/26 21:14:01  kalli
# Erste Version mit wiederholten Terminen
#
# Revision 1.1  1996/11/24 19:24:37  kalli
# Initial revision
#

use Date::Parse;
use Date::Format;

sub GetMeetings4Plan {

    select((select(STDOUT), $|=1)[$[]);
    
    if ( $Private ne "P" ) {
	$Private = "-";
    }

    # start counter
    $MeetingCounter = 0;
    $RepMeetingCounter = 0;
    $RepNotesCounter = 0;
    $CalendarNotesCounter = 0;

    # save old plan file
    if (-e "$PlanFile") {
	rename ("$PlanFile", "$PlanFile.bak");
    }

    # Open new plan file
    open (PLFILE, ">> $PlanFile")  || die "Can't open File : $!\n";

    # first save the header information from an old planfile
    if (-e "$PlanFile.bak"){
	open (PLOLD, "$PlanFile.bak");
        while(<PLOLD>){
	    if (/^[aelmoOpPtuUy]/){
	        print PLFILE;
	    }
	}
    }

    # send commands to Sloup
    &send_line (COMNEWTON, "\nCalendar");
    &send_line (COMNEWTON, '{class: "string", mtgText: "string", mtgStartDate: "dateTime", mtgDuration: "time"}'); 
    &send_line (COMNEWTON, "DUMP!{fieldDelimiter: \"\t\"}");

    while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	# replace german Umlaute
	if ($SystemType eq "IRIX") {	
	    s/\232//g; s/\212//g; s/\237//g; s/\247//g; s/\205//g; s/\200//g; s/\206//g;
	}
	else {
	    s/\232//g; s/\212//g; s/\237//g; s/\247//g; s/\205//g; s/\200//g; s/\206//g;
	}
	# split into
	($PLclass, $PLmtgText, $PLmtgStartDate, $PLmtgDuration) = split(/\t/, $_, 20);
	# remove all carrige return from meeting text
	# $PLmtgText =~ s/\n/ /g;
	# $PLmtgText =~s/\r/ /g;
	# split date/time
	($PLmtgStartDateGer, $PLmtgStartTime) = split(/ /, $PLmtgStartDate, 10);
	# transfer different dateformates to US date
	if ($DateFormat eq "German"){
		($PLday, $PLmonth, $PLyear) = split(/\./, $PLmtgStartDateGer, 10);
	} elsif ($DateFormat eq "British"){
		($PLday, $PLmonth, $PLyear) = split(/\//, $PLmtgStartDateGer, 10);
        } elsif ($DateFormat eq "US"){
		($PLmonth, $PLday, $PLyear) = split(/\//, $PLmtgStartDateGer, 10);
	} else {
		die "Date format not recognised";
	}
	# transfer time in minutes to hours
	$PLmtgDurationhours = int ($PLmtgDuration / 60);
	$PLmtgDurationminutes = $PLmtgDuration % 60;

	if (defined ($PLclass) && ($PLclass eq "meeting")) {

	    # Print to STDOUT
	    print "#";
	    $MeetingCounter++;
	    print PLFILE "$PLmonth/$PLday/$PLyear  $PLmtgStartTime:0  $PLmtgDurationhours:$PLmtgDurationminutes:0  0:45:0  0:5:0 -$Private-------- 0\n";
	    # write to file : Meeting text
	    print PLFILE "N\t$PLmtgText\n";

	}
    }

    # Print to STDOUT
    print "\nNow scanning for repeat meetings ...\n";

    if ($SystemType eq "IRIX") {
        close COMNEWTON;
        open (COMNEWTON, "+>$tty");
        &SetSloupBaudrate;
        printf (COMNEWTON "\n");
    }


    # send commands to Sloup
    &send_line (COMNEWTON, "\nRepeat Meetings");
    &send_line (COMNEWTON, '{class: "string", mtgText: "string", mtgStartDate: "dateTime", mtgStopDate: "dateTime",' .
                           'mtgDuration: "time", mtgAlarm: "time", repeatType: "integer"}');
    &send_line (COMNEWTON, "DUMP!{fieldDelimiter: \"\t\"}");

    while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	# replace german Umlaute
	if ($SystemType eq "IRIX") {	
	    s/\232//g; s/\212//g; s/\237//g; s/\247//g; s/\205//g; s/\200//g; s/\206//g;
	}
	else {
	    s/\232//g; s/\212//g; s/\237//g; s/\247//g; s/\205//g; s/\200//g; s/\206//g;
	}

	# split into
	($PLRclass, $PLRmtgText, $PLRmtgStartDate, $PLRmtgStopDate, $PLRmtgDuration,
         $PLRmtgAlarm, $PLRmtgRepeatType) = split(/\t/, $_, 20);
	# remove \n from $PLRmtgText
	$PLRmtgText =~ s/\n/\t/g;
	# split date/time
	($PLRmtgStartDateGer, $PLRmtgStartTime) = split(/ /, $PLRmtgStartDate, 10);
	# transfer different dateformates to US date
	if ($DateFormat eq "German") {
		($PLRday, $PLRmonth, $PLRyear) = split(/\./, $PLRmtgStartDateGer, 10);
	} elsif ($DateFormat eq "British"){
		($PLRday, $PLRmonth, $PLRyear) = split(/\//, $PLRmtgStartDateGer, 10);
	} elsif ($DateFormat eq "US") {
		($PLRmonth, $PLRday, $PLRyear) = split(/\//, $PLRmtgStartDateGer, 10);
	} else {
		die "Dateformat not recognised";
	}
        #Plan begins year counting with 1970
        if ($PLRyear < 1970) {
                $PLRyear = 1970
        }
	# split date/time
	($PLRmtgStopDateGer, $PLRmtgStopTime) = split(/ /, $PLRmtgStopDate, 10);
	# transfer different dateformates to US date
	if ($DateFormat eq "German"){
		($PLRStopday, $PLRStopmonth, $PLRStopyear) = split(/\./, $PLRmtgStopDateGer, 10);
	} elsif ($DateFormat eq "British"){
		($PLRStopday, $PLRStopmonth, $PLRStopyear) = split(/\//, $PLRmtgStopDateGer, 10);
	} elsif ($DateFormat eq "US"){
		($PLRStopmonth, $PLRStopday, $PLRStopyear) = split(/\//, $PLRmtgStopDateGer, 10);
	} else {
		die "Dateformat not recognised";
	}

	# transfer time in minutes to hours
	$PLRmtgDurationhours = int ($PLRmtgDuration / 60);
	$PLRmtgDurationminutes = $PLRmtgDuration % 60;
	$PLRmtgAlarmhours = int ($PLRmtgAlarm / 60);
	$PLRmtgAlarmminutes = $PLRmtgAlarm % 60;

	if (defined ($PLRclass) && ($PLRclass eq "meeting")) {

	    # Print to STDOUT
	    print "#";
	    $RepMeetingCounter++;

	    # if repeat every week
	    if ($NTRmtgRepeatType == 0) {

		# write to file 
		print PLFILE "$PLRmonth/$PLRday/$PLRyear  $PLRmtgStartTime:0  $PLRmtgDurationhours:$PLRmtgDurationminutes:0  0:0:0  $PLRmtgAlarmhours:$PLRmtgAlarmminutes:0 -$Private-------- 0\n";
		# get weekday
		#printf ("\nRepeat every week : $PLRyear/$PLRmonth/$PLRday");
		$PLRtowa = Date::Parse::str2time ("$PLRyear/$PLRmonth/$PLRday");
		$PLRtow = Date::Format::time2str ("%a", $PLRtowa);
		#printf ("Tag : $PLRtow");

		# check for unlimited repeat meeting 
		if ( ($PLRStopday eq "29") && ($PLRStopmonth eq "9") &&
                     ($PLRStopyear eq "") && ($PLRmtgStopTime eq "0:31") ) {

		    # write to file : Unlimited repeat
		    print PLFILE "R\t 0 0 1 0 0\n"  if ($PLRtow eq "Sun");
		    print PLFILE "R\t 0 0 2 0 0\n"  if ($PLRtow eq "Mon");
		    print PLFILE "R\t 0 0 4 0 0\n"  if ($PLRtow eq "Tue");
		    print PLFILE "R\t 0 0 8 0 0\n"  if ($PLRtow eq "Wed");
		    print PLFILE "R\t 0 0 16 0 0\n" if ($PLRtow eq "Thu");
		    print PLFILE "R\t 0 0 32 0 0\n" if ($PLRtow eq "Fri");
		    print PLFILE "R\t 0 0 64 0 0\n" if ($PLRtow eq "Sat");

		} else {

		    # get time since 1/1/70 0:0:0
		    $CC = "$PLRStopmonth/$PLRStopday/$PLRStopyear $PLRmtgStopTime\n";
		    $NTRRtowa = Date::Parse::str2time($CC);
		    #$NTRRtowa = $NTRRtowa+1 - 82740;
		    $NTRRtowa = $NTRRtowa+1;
		    # write to file : Repeat with limit
		    print PLFILE "R\t 0 $NTRRtowa 1 0 0\n"  if ($PLRtow eq "Sun");
		    print PLFILE "R\t 0 $NTRRtowa 2 0 0\n"  if ($PLRtow eq "Mon");
		    print PLFILE "R\t 0 $NTRRtowa 4 0 0\n"  if ($PLRtow eq "Tue");
		    print PLFILE "R\t 0 $NTRRtowa 8 0 0\n"  if ($PLRtow eq "Wed");
		    print PLFILE "R\t 0 $NTRRtowa 16 0 0\n" if ($PLRtow eq "Thu");
		    print PLFILE "R\t 0 $NTRRtowa 32 0 0\n" if ($PLRtow eq "Fri");
		    print PLFILE "R\t 0 $NTRRtowa 64 0 0\n" if ($PLRtow eq "Sat");

	        }

	    } else {
		# write to file : Repeat
		print PLFILE "R\t 0 0 0 0 0\n";
	    }

	    # write to file : Meeting text
	    print PLFILE "N\t$PLRmtgText\n";

	}
    }

    # Print to STDOUT
    print "\nNow scanning for repeat notes ...\n";

    if ($SystemType eq "IRIX") {
        close COMNEWTON;
        open (COMNEWTON, "+>$tty");
        &SetSloupBaudrate;
        printf (COMNEWTON "\n");
    }

    # send commands to Sloup
    &send_line (COMNEWTON, "\nRepeat Notes");
    &send_line (COMNEWTON, '{class: "string", mtgText: "string", mtgStartDate: "dateTime", mtgStopDate: "dateTime", ' .
                           'mtgDuration: "time", mtgAlarm: "time", repeatType: "integer"}'); 
    &send_line (COMNEWTON, "DUMP!{fieldDelimiter: \"\t\"}");

    while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	# replace german Umlaute
	if ($SystemType eq "IRIX") {	
	    s/\232//g; s/\212//g; s/\237//g; s/\247//g; s/\205//g; s/\200//g; s/\206//g;
	}
	else {
	    s/\232//g; s/\212//g; s/\237//g; s/\247//g; s/\205//g; s/\200//g; s/\206//g;
	}

	# split into
	($NTRclass, $NTRmtgText, $NTRmtgStartDate, $NTRmtgStopDate, $NTRmtgDuration, 
         $NTRmtgAlarm, $NTRmtgRepeatType) = split(/\t/, $_, 20);
	# remove \n from $NTRmtgText
	$NTRmtgText =~ s/\n/\t/g;
	# split date/time
	($NTRmtgStartDateGer, $NTRmtgStartTime) = split(/ /, $NTRmtgStartDate, 10);
	# transfer German date to US date
	if ($DateFormat eq "German"){
		($NTRday, $NTRmonth, $NTRyear) = split(/\./, $NTRmtgStartDateGer, 10);
	} elsif ($DateFormat eq "British"){
		($NTRday, $NTRmonth, $NTRyear) = split(/\//, $NTRmtgStartDateGer, 10);
	} elsif ($DateFormat eq "US"){
		($NTRmonth, $NTRday, $NTRyear) = split(/\//, $NTRmtgStartDateGer, 10);
	} else {
		die "Dateformat not recognised";
	}
	#Plan begins year counting with 1970
	if ($NTRyear < 1970) {
		$NTRyear = 1970
	}
	# split date/time
	($NTRmtgStopDateGer, $NTRmtgStopTime) = split(/ /, $NTRmtgStopDate, 10);
	# transfer different dateformates to US date
	if ($DateFormat eq "German"){
		($NTRStopday, $NTRStopmonth, $NTRStopyear) = split(/\./, $NTRmtgStopDateGer, 10);
	} elsif ($DateFormat eq "British"){
		($NTRStopday, $NTRStopmonth, $NTRStopyear) = split(/\//, $NTRmtgStopDateGer, 10);
	} elsif ($DateFormat eq "US"){
		($NTRStopmonth, $NTRStopday, $NTRStopyear) = split(/\//, $NTRmtgStopDateGer, 10);
	} else {
		die "Dateformat not recognised";
	}
	# transfer time in minutes to hours
	$NTRmtgDurationhours = int ($NTRmtgDuration / 60);
	$NTRmtgDurationminutes = $NTRmtgDuration % 60;
	$NTRmtgAlarmhours = int ($NTRmtgAlarm / 60);
	$NTRmtgAlarmminutes = $NTRmtgAlarm % 60;

	if (defined ($NTRclass) && ($NTRclass eq "meeting")) {

	    # Print to STDOUT
	    print "#";
	    $RepNotesCounter++;

	    # if repeat every year
	    if ($NTRmtgRepeatType == 3) {
		# write to file : date / time of day / duration / late warning / early warning
		print PLFILE "$NTRmonth/$NTRday/$NTRyear  99:99:99  $NTRmtgDurationhours:$NTRmtgDurationminutes:0  0:0:0  0:0:0 -$Private-------- 0\n";
		# write to file : Repeat
		print PLFILE "R\t0 0 0 0 1\n";

	    # if repeat every day
	    } elsif ($NTRmtgRepeatType == 0) {
		# write to file : date / time of day / duration / late warning / early warning
		print PLFILE "$NTRmonth/$NTRday/$NTRyear  99:99:99  0:0:0  0:0:0  0:0:0 -$Private-------- 0\n";
		# get time since 1/1/70 0:0:0
		$CC = "$NTRStopmonth/$NTRStopday/$NTRStopyear $NTRmtgStopTime\n";
		#$NTRRtowa = `$ConvdateCommand -n '$CC'`;
		$NTRRtowa = Date::Parse::str2time($CC);
		$NTRRtowa = $NTRRtowa+1 - 82740;
		# write to file : Repeat
		print PLFILE "R\t86400 $NTRRtowa 0 0 0\n";

	    } else {
		# write to file : Repeat
		#print PLFILE "R\t 0 0 0 0 0\n";
	    }

	    # write to file : Meeting text
	    print PLFILE "N\t$NTRmtgText\n";

	}
    }

    # Print to STDOUT
    print "\nNow scanning for calendar notes ...\n";

    if ($SystemType eq "IRIX") {
        close COMNEWTON;
        open (COMNEWTON, "+>$tty");
        &SetSloupBaudrate;
        printf (COMNEWTON "\n");
    }


    # send commands to Sloup
    &send_line (COMNEWTON, "\nCalendar Notes");
    &send_line (COMNEWTON, '{class: "string", mtgText: "string", mtgStartDate: "dateTime"}'); 
    &send_line (COMNEWTON, "DUMP!{fieldDelimiter: \"\t\"}");

    while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	# replace german Umlaute
	if ($SystemType eq "IRIX") {	
	    s/\232//g; s/\212//g; s/\237//g; s/\247//g; s/\205//g; s/\200//g; s/\206//g;
	}
	else {
	    s/\232//g; s/\212//g; s/\237//g; s/\247//g; s/\205//g; s/\200//g; s/\206//g;
	}

	# split into
	($CNclass, $CNmtgText, $CNmtgStartDate) = split(/\t/, $_, 20);
	# remove \n from $CNmtgText
	$CNmtgText =~ s/\n/\t/g;
	# split date/time
	($CNmtgStartDateGer, $CNmtgStartTime) = split(/ /, $CNmtgStartDate, 10);
	# transfer different dateformates to US date
	if ($DateFormat eq "German"){
		($CNday, $CNmonth, $CNyear) = split(/\./, $CNmtgStartDateGer, 10);
	} elsif ($DateFormat eq "British"){
		($CNday, $CNmonth, $CNyear) = split(/\//, $CNmtgStartDateGer, 10);
	} elsif ($DateFormat eq "US"){
		($CNmonth, $CNday, $CNyear) = split(/\//, $CNmtgStartDateGer, 10);
	} else {
		die "Dateformat not recoginsed";
	}
        #Plan begins year counting with 1970
        if ($CNyear < 1970) {
                $CNyear = 1970
        }
	if (defined ($CNclass) && ($CNclass eq "meeting")) {

	    # Print to STDOUT
	    print "#";
	    $CalendarNotesCounter++;
	    print PLFILE "$CNmonth/$CNday/$CNyear  99:99:99  0:0:0  0:0:0  0:0:0 -$Private-------- 0\n";
	    # write to file : Meeting text
	    print PLFILE "N\t$CNmtgText\n";

	}
    }

    # close file
    close (PLFILE);

    # print to stdout
    print ("\n$MeetingCounter meetings transfered");
    print ("\n$RepMeetingCounter repeat meetings transfered");
    print ("\n$RepNotesCounter repeat notes transfered");
    print ("\n$CalendarNotesCounter calendar notes transfered");

}

1;
