#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#-----------------------------------------------------------------------
# DeviceReadWrite
#-----------------------------------------------------------------------

# $Log: DeviceReadWrite.pl,v $
# Revision 1.4  1998/09/01 13:52:32  kalli
# Im Fehlerfall wird String zurueckgegeben (wg. GreetUser.pl)
#
# Revision 1.3  1998/03/16 14:56:43  kalli
# Erste lauffaehige Version mit Timeout
#
# Revision 1.2  1998/03/08 20:45:21  kalli
# Neu mit Timeout
#
# Revision 1.1  1998/03/06 22:53:02  kalli
# Initial revision
#

# This function writes the string given by the second parameter to the 
# filehandle, given by the first parameter. The string is terminated with an 
# carriage return.

sub send_line {
   #print "$_[1]\n";
   syswrite ($_[0], "$_[1]\r", length ($_[1])+1) || die "sub send_line: write systemcall failed";
}


# This functions reads one line from the filehandle, given by the first 
# parameter. The line must be terminated with an carriage return or a line 
# feed or both. The return value is the read string.

sub receive_line {

    $SerialInBuffer  = "";              # clear input buffer
    $LastSerialInChar = "";
    $MAX_Time_Out    = 4;		# number out timeout
    $Time_Out_Count  = 0;		# time out counter

    vec ($vin, fileno (COMNEWTON), 1) = 1;

    # read until EOL or timeout
    while (1) {
    
        ($nfound, $timeleft) = select ($vout = $vin, undef, undef, $timeout);

	# not timed out
        if ($nfound != 0) {

            # try to read one character
            if (sysread ($_[0], $SerialInChar, 1) < 0)  {
	        print " Error read from Newton\n";
	     	  
	    } else {
	    
	        # print Hexdump for Debug
                #$nin = ord ($SerialInChar);
		#printf ("%0x ", $nin);
		
	        # reset timout counter
	        $Time_Out_Count = 0;

	        # line end reached (0a/0a) ?
                if (($LastSerialInChar eq "\x0a") && ($SerialInChar eq "\x0a")) {
                    # remove last 0a
                    chop $SerialInBuffer;
		    return $SerialInBuffer;
                } else {
                    $SerialInBuffer = $SerialInBuffer . $SerialInChar;
		    $LastSerialInChar = $SerialInChar;
	        }
	    }

	} else	{ 

            # blink for wait
	    $Time_Out_Count++;

            # timeout reached, stop
	    if ( $Time_Out_Count > $MAX_Time_Out) { 
	       #die "\nNewton connection timeout\n";
               return "Timeout reached";
	    }
	}
	
	$nfound = 0;
    }
}

1;
