//
//  Newtl!  Newton/UNIX Communication System!
//  Copyright (C) 1995-1997  A. E. Hall
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

char newtl_C_rcsid[] = "$Id: newtl.C,v 1.6 1997/09/20 16:26:46 spoonman Exp spoonman $";

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/file.h>
#include <String.h>
#include <BitString.h>
#include "newtl.H"
#include "Newton.H"

#include <Regex.h> // aehall

#define RCSID "$Id: " // this is so RCS doesn't replace it...
char newtl_C_copyright[] = RCSID NewtlTITLE " " NewtlCOPYRIGHT " $";

int main(int argc, char *argv[])
  {
  String DeviceName=NewtonDEVICE;
  int error=0;
  BitString options;
  int loop, BaudRate=0;
  extern int optind;
  char letter;
  String SlurpeeFile, ReceiveFile, PackageFile;
  static struct option const long_options[] =
    {
    {"device",   required_argument, 0, 'd'},
    {"slurpee",  required_argument, 0, 's'},
    {"transmit", no_argument,       0, 't'},
    {"npp",      no_argument,       0, 'n'},
    {"receive",  required_argument, 0, 'r'},
    {"email",    no_argument,       0, 'e'},
    {"print",    no_argument,       0, 'p'},
    {"fax",      no_argument,       0, 'f'},
#ifdef NewtonYAPI
    {"xmodem",   required_argument, 0, 'x'},
#endif
    {"baud",     required_argument, 0, 'b'},
    {"quiet",    no_argument,       0, 'q'},
    {"load",     required_argument, 0, 'l'},
    {0, 0, 0, 0}
    };
  Newton *myNewt;

  Regex RXat("^AT.*"); // aehall


  // Get Options!
  options = atoBitString("00000000", '0', '1');
#ifdef NewtonYAPI
  while ((letter=getopt_long(argc,argv,"dstnrepfxbql",long_options,(int *)0)) 
          != EOF)
#else
  while ((letter=getopt_long(argc,argv,"dstnrepfbql",long_options,(int *)0)) 
          != EOF)
#endif
    {
    switch(letter)
      {
      case 'd':            // the device
        DeviceName = argv[optind++];
        break;
      case 's':            // the Slurpee init file
        SlurpeeFile = argv[optind++];
        options.set(OPT_slurpee);
        break;
      case 't':
        options.set(OPT_transmit);
        break;
      case 'n':            // the Newton PreProcessor (npp)
        options.set(OPT_npp);
        break;
      case 'r':
        ReceiveFile = argv[optind++];
        options.set(OPT_receive);
        break;
      case 'e':
        options.set(OPT_email);
        break;
      case 'p':
        options.set(OPT_print);
        break;
      case 'f':
        options.set(OPT_fax);
        break;
#ifdef NewtonYAPI
      case 'x':
        options.set(OPT_packxmodem);
        PackageFile = argv[optind++];
        break;
#endif
      case 'b':
        options.set(OPT_baudrate);
        BaudRate = atoi(argv[optind++]);
        break;
      case 'q':
        options.set(OPT_quiet);
        break;
      case 'l':
        options.set(OPT_package);
        PackageFile = argv[optind++];
        break;
      };
    };

  if (!options.test(OPT_quiet))
    {
    fprintf(stdout, "%s\n      %s\n",NewtlTITLE, NewtlCOPYRIGHT);
    };

  // if none of the required options are given, error...
  if (!options.test(OPT_transmit) && !options.test(OPT_receive) &&
      !options.test(OPT_email) && !options.test(OPT_print) &&
      !options.test(OPT_fax) && !options.test(OPT_packxmodem) &&
      !options.test(OPT_package))
    {
    error = 1;
    };

  if (error)
    {
#ifdef NewtonYAPI
    fprintf(stderr,"Usage: %s [-q] [-d devicename] [-s slurpeefile]\n"
                   "       [-b baud] -t|-r|-e|-p|-f|-x|-l ...\n",argv[0]);
#else
    fprintf(stderr,"Usage: %s [-q] [-d devicename] [-s slurpeefile]\n"
                   "       [-b baud] -t|-r|-e|-p|-f|-l ...\n",argv[0]);
#endif
    fprintf(stderr,"    -d|--device devicename        Newton Device\n");
    fprintf(stderr,"    -s|--slurpee slurpeefile      Slurpee Init File\n");
    fprintf(stderr,"    -b|--baud baudrate            Serial Line Baud Rate\n");
    fprintf(stderr,"    -t|--transmit [filename...]   Send files\n");
    fprintf(stderr,"        -n --npp                  Newt PreProcessor\n");
    fprintf(stderr,"    -r|--receive filename         Receive to file\n");
    fprintf(stderr,"    -e|--email                    Email Outbox\n");
    fprintf(stderr,"    -p|--print                    Print Outbox\n");
    fprintf(stderr,"    -f|--fax                      Fax Outbox\n");
#ifdef NewtonYAPI
    fprintf(stderr,"    -x|--xmodem filename          Install a package\n");
#endif
    fprintf(stderr,"    -l|--load filename            Install a package\n");
    fprintf(stderr,"  All functions use Slurpee, except -x which uses YAPI\n");
    fprintf(stderr,"  and -l which uses Newton's Connection.\n");
    fprintf(stderr,"  The default baudrate is 9600 (19200 for YAPI.\n");
    fprintf(stderr,"  If -d is not used, %s is assumed.\n",NewtonDEVICE);
    fprintf(stderr,"  The -t and -r options require the -s option.\n");
    fprintf(stderr,"  The NPP can only be used when transmitting.\n");
#ifdef NewtonYAPI
    fprintf(stderr,"  The -x option sends a Newton package using X-MODEM.\n");
#endif
    exit(1);
    };

  if (!options.test(OPT_quiet))
    {
    fprintf(stdout,"Opening Newton at [%s]\n", DeviceName.chars());
    };
  myNewt = new Newton;

  if (BaudRate == 0)
    {
    if (options.test(OPT_packxmodem))
      {
      myNewt->Open(DeviceName, 19200, 8, 'N', 1);  // the standard YAPI speed
      }
    else
      {
      myNewt->Open(DeviceName, 9600, 8, 'N', 1);  // the standard Slurpee speed
      };
    }
  else
    {
    myNewt->Open(DeviceName, BaudRate, 8, 'N', 1);// the standard Slurpee speed
    };


  //
  // Get the Slurpee init file
  //
  if (options.test(OPT_slurpee))
    {
    if (!options.test(OPT_quiet))
      {
      fprintf(stdout,"Initializing [%s]\n", SlurpeeFile.chars());
      };
    myNewt->WriteFromFile(SlurpeeFile, TRUE);
    myNewt->WriteFromFile(SlurpeeFile, TRUE);
    };

/*
  if (myNewt->isConnected())
    {
    fprintf(stdout,"CONN!\n");
    }
  else
    {
    fprintf(stderr,"Either a Newton is not connected to %s\n", NewtonDEVICE);
    fprintf(stderr,"or Slurpee is not running on the Newton.\n");
    exit(2);
    };
*/

  //
  // Transmit
  //
  if (options.test(OPT_transmit))
    {
    for (loop=optind; loop < argc; loop++)
      {
      if (!options.test(OPT_quiet))
        {
        fprintf(stdout,"Loading [%s]\n",argv[loop]);
        };

      if (options.test(OPT_npp)) 
        {
        // TRUE for the NewtPreProcessor!
        myNewt->WriteFromFile(argv[loop], TRUE);
        }
      else
        {
        myNewt->WriteFromFile(argv[loop], FALSE);
        };

      // write only if in Notes
      myNewt->WriteString("-----\n");
      };

    // don't output BYE! if no files were transmitted to Newton
    // this is so a soup called "BYE" isn't created
    if (loop != optind)
      {
      myNewt->WriteString(SlurpeeBYE);
      };
    };


  // 
  // Receive
  //
  if (options.test(OPT_receive))
    {
    myNewt->ReadToFile(ReceiveFile);
/*
    this is for testing receiving email from
    Newton using Outbox's built in Mail with
    a Hayes Compatible modem enabled on Newton

    myNewt->ReadLine(SlurpeeFile);
    while (SlurpeeFile + "\n" != SlurpeeBYE)
      {
      fprintf(stdout,"[%s]\n", SlurpeeFile.chars());
      if (SlurpeeFile.contains(RXat))
        {
        fprintf(stdout,"OK\n");
        myNewt->WriteString("OK\n");
        };
      fflush(stdout);
      myNewt->ReadLine(SlurpeeFile);
      };
*/
    };


  //
  // Email
  //
  if (options.test(OPT_email))
    {
    myNewt->EmailOutbox();
    };


  //
  // Print
  //
  if (options.test(OPT_print))
    {
    myNewt->PrintOutbox();
    };


  //
  // Print
  //
  if (options.test(OPT_fax))
    {
    myNewt->FaxOutbox();
    };


#ifdef NewtonYAPI
  //
  // Load Package using X-MODEM
  //
  if (options.test(OPT_packxmodem))
    {
    myNewt->LoadPackageXMODEM(PackageFile);
    };
#endif
 
 
  //
  // Load Package
  //
  if (options.test(OPT_package))
    {
    myNewt->LoadPackage(PackageFile);
    };


  //
  // Close Newton
  //
  if (!options.test(OPT_quiet))
    {
    fprintf(stdout,"Closing Newton\n");
    };
  myNewt->Close();
  delete myNewt;

  return(0);
  };

