//
//  Newton Connection Library - Newton/UNIX Connectivity
//  Copyright (C) 1995-1997  A. E. Hall
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

char Outbox_C_rcsid[] = "$Id: Outbox.C,v 1.3 1997/08/24 21:38:02 spoonman Exp $";

#include <stdlib.h>
#include <unistd.h>
#include <regex.h>
#include "Newton.H"

// The Newtl Outbox Processor!!!

enum process_type { OUTBOXnone, OUTBOXprint, OUTBOXfax, OUTBOXbeam,
                    OUTBOXemail };

// Send the stuff to the Printer!
int Newton::PrintOutbox()
  {
  return(ProcessOutbox(OUTBOXprint));
  };

// send the stuff to the Fax!
int Newton::FaxOutbox()
  {
  return(ProcessOutbox(OUTBOXfax));
  };

// send the stuff to InfraRed!
int Newton::BeamOutbox()
  {
  return(ProcessOutbox(OUTBOXbeam));
  };

// send the stuff to Email!
int Newton::EmailOutbox()
  {
  return(ProcessOutbox(OUTBOXemail));
  };

// Process Newton's Outbox
//   1) read through all the entries in Outbox,
//     a) process and send any email slips,
//     b) save the IDs of any print, fax, or beam slips
//   2) print, fax, or beam all the IDs saved in step 1
//
//   Email contains the actual text of the message,
//   print, fax, and beam jobs have a link to the
//   soup (appSymbol) and _uniqueID (pageID) of the stuff
//   to be printed, faxed, or beamed.

int Newton::ProcessOutbox(const int whichOutbox)
  {
  String string, fromString, slipParts[1024], outputFileName;
  SFile outputFile;
  String EmailFromAddress, EmailFromName, EmailFromDate;
  String EmailToAddress, EmailToName, AllTitle, PFBpageID, PFBappSymbol;
  String EmailText, Command="", FaxPhoneNumber;
  String PrintAppSymbols[255], FaxAppSymbols[255], BeamAppSymbols[255];
  String PrintIDs[255], FaxIDs[255], BeamIDs[255], FaxPhoneNumbers[255];
  int printIds=0, faxIds=0, beamIds=0;
  int loop;
  Regex RXoutbox("^outbox\t.*");
  Regex RXprintSlip("^outbox\tprintslip\t.*");
  Regex RXfaxSlip("^outbox\tfaxslip\t.*");
  Regex RXbeamSlip("^outbox\tzapslip\t.*");
  Regex RXmailSlip("^outbox\tmailSlip\t.*");
  Regex RXpaperRoll("paperRoll");
  Regex RXdelimiter("\t");

  // Snag the Outbox!
  WriteString("Outbox\n");
  WriteString("{"                              /* Which Slip       */ \
              "box: 'string, "                 /* All              */ \
              "category: 'string, "            /* All              */ \
              "title: 'string, "               /* All              */ \
              "fromEmailaddress: 'string, "    /* Email            */ \
              "fromName: 'string, "            /* Email            */ \
              "dateStr: 'string, "             /* Email            */ \
              "toEmailAddress: 'string, "      /* Email            */ \
              "name: 'string, "                /* Email            */ \
              "text: 'string, "                /* Email            */ \
              "pageID: 'string, "              /* Print, Fax, Beam */ \
              "phonenumber: 'string, "         /* Fax              */ \
              "appSymbol: 'string"             /* Print, Fax, Beam */ \
              "}\n");
  WriteString(SlurpeeDUMP);

  // read Slurpee until it's DONE!
  ReadLine(string);
  while (string + "\n" != SlurpeeBYE)
    {
    // Process each Outbox entry
    if (string.contains(RXoutbox))
      {
      // close and process any previously opened tmp files
      if (outputFile.is_open())
        {
        outputFile.close();
        if (Command != "")
          {
          system(Command);
          };
        unlink(outputFileName);
        };

      // open the output file
      outputFileName = tmpnam(NULL);
      outputFile.open(outputFileName, 2048, ios::out, 0600);
      if (!outputFile.is_open())
        {
        fprintf(stderr, "newtl: Cannot open file: %s\n",outputFileName.chars());
        return(NewtonERROR);
        };

      // Get Address Slip parts
      split(string, slipParts, 20, RXdelimiter);
      AllTitle         = slipParts[2];
      EmailFromAddress = slipParts[3];
      EmailFromName    = slipParts[4];
      EmailFromDate    = slipParts[5];
      EmailToAddress   = slipParts[6];
      EmailToName      = slipParts[7];
      EmailText        = slipParts[8] + "\n";
      PFBpageID        = slipParts[9];
      FaxPhoneNumber   = slipParts[10];
      PFBappSymbol     = slipParts[11];
      Command = "";

      // PRINT - get the IDs of the notes to be printed, faxed, or beamed
      if (string.contains(RXprintSlip))
        {
        PrintAppSymbols[printIds] = PFBappSymbol;
        PrintIDs[printIds] = PFBpageID;
        printIds += 1;
        };

      // FAX
      if (string.contains(RXfaxSlip) && (whichOutbox == OUTBOXfax))
        {
        fprintf(stderr,"FAX: %s\n",string.chars());
        FaxAppSymbols[printIds] = PFBappSymbol;
        FaxIDs[faxIds] = PFBpageID;
        FaxPhoneNumbers[faxIds] = FaxPhoneNumber;
        faxIds += 1;
        };

      // BEAM
      if (string.contains(RXbeamSlip) && (whichOutbox == OUTBOXbeam))
        {
        fprintf(stderr,"BEAM: %s\n",string.chars());
        BeamAppSymbols[printIds] = PFBappSymbol;
        BeamIDs[beamIds] = PFBpageID;
        beamIds += 1;
        };

      // EMAIL
      if (string.contains(RXmailSlip) && (whichOutbox == OUTBOXemail))
        {
        fromString = " From Newton/Newtl: " + EmailFromName + \
                    " <" + EmailFromAddress + "> " + EmailFromDate + "\n" + \
                    " To: " + EmailToName + " <" + EmailToAddress + ">\n\n";
        Command = unixMAIL;
#ifdef unixMAILsubject
        // the String object doesn't like char* + char*
        Command += " " + EmailToAddress + " ";
        Command += unixMAILsubject;
        Command += " \"" + AllTitle + "\" < " + outputFileName;
#else
        Command += " " + EmailToAddress + " < " + outputFileName;
#endif
        outputFile.write(fromString, fromString.length());
        outputFile.write(EmailText, EmailText.length());
        };


      string = "";  // clear string so there's no output below!
      };

    // Process the Email Body of the message!
    if ((string != "") && (!string.contains(RXpaperRoll)))
      {
      string += "\n";
      outputFile.write(string, string.length());
      outputFile.flush();
      };

    ReadLine(string);
    };

  // close and process the final open tmp file, if any
  if (outputFile.is_open())
    {
    outputFile.close();
    if (Command != "")
      {
      system(Command);
      };
    unlink(outputFileName);
    };




  //
  // PRINT all the IDs
  //
  if (whichOutbox == OUTBOXprint)
    {
    for (loop=0; loop < printIds; loop++)
      {
      // Currently only works for Notes soups
      if (PrintAppSymbols[loop].contains(RXpaperRoll))
        {
        outputFileName = tmpnam(NULL);
        PrintAppSymbols[loop] = "Notes";
        WriteString(PrintAppSymbols[loop] + "\n");
        WriteString("{ _uniqueID: " + PrintIDs[loop] + "}\n");
        WriteString(SlurpeeDUMP);
        ReadToFile(outputFileName);
        Command = unixPRINT; // the String object doesn't like char* + char*
        Command += " " + outputFileName;
        system(Command);
        unlink(outputFileName);
        };
      };
    };


  //
  // FAX all the IDs
  //
  if (whichOutbox == OUTBOXfax)
    {
    for (loop=0; loop < faxIds; loop++)
      {
      // Currently only works for Notes soups
      if (FaxAppSymbols[loop] == "paperRoll")
        {
        outputFileName = tmpnam(NULL);
        FaxAppSymbols[loop] = "Notes";
        WriteString(FaxAppSymbols[loop] + "\n");
        WriteString("{ _uniqueID: " + FaxIDs[loop] + "}\n");
        WriteString(SlurpeeDUMP);
        ReadToFile(outputFileName);
        Command = unixFAX;  // the String object doesn't like char* + char*
        Command += " " + FaxPhoneNumbers[loop] + " " + outputFileName + " &";
        system(Command);
        unlink(outputFileName);
        };
      };
    };


  //
  // BEAM all the IDs
  //
  if (whichOutbox == OUTBOXbeam)
    {
    fprintf(stderr,"BEAM: \"Beam me up, Scotty!\"\n");
    fprintf(stderr,"BEAM: How should I handle BEAM stuff???\n");
    };


  return(NewtonOK);
  };

