#! /usr/bin/env python1.5
#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/CVS/gnuton/lib/GnutOS/Package.py,v $
# Version:     $RCSfile: Package.py,v $ $Revision: 1.6 $
# Copyright:   (C) 1998-2000, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""

"""

#############################################################################

import struct, sys

from   GnutOS.Constants          import *
from   GnutOS.Classes            import *


#############################################################################

#-- package directory signatures
PACKAGE0 = "package0"
PACKAGE1 = "package1"


#############################################################################
#  exception classes


class PackageError:
    def __init__(self, *vargs, **kargs):
	self.vargs = vargs
	self.kargs = kargs

    def __str__(self):
	return str(self.vargs) + str(self.kargs)


class BadSignature(PackageError):
    pass



#############################################################################

class Installer:
    """
    Format of the 'Packages' soup:

    A normal app ...

    pkgRef: (binary, 147828 bytes)
    _tagList: ['_package]
    packageName: "TimeTrax:SRS"
    _modTime: 49564323
    _uniqueID: 98
    
    _app: 'TimeTrax:SRS
    class: 'FormEntry
    sequence: 43
    iconPro: {unhilited: {bits: (binary, 116 bytes), mask:(binary, 116 bytes), bounds: {left: 0, top: 0, right: 32, bottom: 25}, colordata: [{?}, {?}]}}
    icon: {bits: (binary, 116 bytes), mask: (binary, 116 bytes), bounds: {left:0, top:0, right:32, bottom:25}}
    packageName: "TimeTrax:SRS"
    labels: nil
    text: "TimeTrax"
    _tagList: ['_icon]
    _uniqueID: 99
    _modTime: 49564327


    Another normal app ...

    pkgRef: (binary, 2644 bytes)
    packageName: "Newt Test:DSTC"
    _tagList: ['_package]
    _uniqueID: 96
    _modTime: 49555461

    app: "Newt Test:DSTC"
    class: 'FormEntry
    sequence: 38
    icon: {bits: (binary, 124 bytes), mask: (binary, 124 bytes), bounds: {left:0, top: 0, right:24, bottom:27}}
    packageName: "Newt Test:DSTC"
    labels: nil
    text: "Newt Test"
    _tagList: ['_icon]
    _uniqueID: 97
    _modTime: 49555461


    A frozen entry ...

    pkgRef: (binary, 22120 bytes)
    packageName: "IconEditor:SBM"
    _tagList: ['_package, '_frozen]
    _uniqueID: 40
    _modTime: 49592189

    app: 'IconEditor:SBM
    class: 'FormEntry
    sequence: 8
    iconPro: {8}
    icon: {3}
    packageName: "IconEditor:SBM"
    labels: 'Utilities
    text: "Icon Editor"
    _tagList: ['_icon, 'Utilities, '_frozen]
    _uniqueID: 41
    _modTime: 49592189

    class: 'FrozenEntry
    sequence: 8
    icon: 9
    packageName: "IconEditor:SBM"
    labels: 'Utilities
    text: "Icon Editor"
    _tagList: ['_icon, '_snowflake, 'Utilities]
    _uniqueID: 102
    _modTime: 49592126


    An weird part (bad auto?) ...

    pkgRef: (binary, 11524 bytes)
    packageName: "Tasks:SBM"
    _tagList: ['_package]
    _uniqueID: 82
    _modTime: 49555233

    class: '????Entry
    sequence: 10
    icon: 6
    packageName: "Tasks:SBM"
    labels: '_extensions
    text: "Tasks:SBM"
    _tagList: ['_icon, '_extensions]
    _uniqueID: 83
    _modTime: 49555233


    An autopart ...

    pkgRef: (binary, 41052 bytes)
    packageName: "NIE LocalTalk Module"
    _tagList: ['_package]
    _uniqueID: 54
    _modTime: 49555231


    class: 'AutoEntry
    TapAction: {
        class: nil
	instructions: (binary, 9 bytes)
	literals: [
	    'NIE LocalTalk Module:NIE_TapActionFunc
	    'GetGlobalVar
	    'AddDeferredCall
        ]
	argFrame: nil
	numArgs: 0
    }
    sequence: 6
    icon: 3
    packageName: "NIE LocalTalk Module"
    labels: '_extensions
    text: "NIE LocalTalk Module"
    _tagList: ['_icon, '_extensions]
    _uniqueID: 55
    _modTime: 49555231


    A font ...

    pkgRef: (binary, 8392 bytes)
    packageName: "Monaco9:Newton"
    _tagList: ['_package]
    _uniqueID: 48
    _modTime: 49555230


    class: '????Entry
    sequence: 11
    icon: 6
    packageName: "Monaco9:Newton"
    labels: '_extensions
    text: "Monaco9:Newton"
    _tagList: ['_icon, '_extensions]
    _uniqueID: 49
    _modTime: 49555230


    A soup

    soupsNames: ["To do", "To Do List"]
    class: 'ROMSoupEntry
    ownerApp: 'calendar
    sequence: 30
    emptyInternal: True
    icon: 4
    labels: '_soups
    text: "To do\nTasks"
    closeControl: 'leaveOpen
    _tagList: ['_icon, '_soups, '_noBackup]
    _uniqueID: 15
    _modTime: 53117653


    Other entries include

    class: 'ROMFormEntry (for ROM-resident apps)
    class: 'ROMScriptEntry (for ROM-resident apps? used by Assist)
    closeControl: True (in the icon entry, set for EnRoute 1.4.2)
    '_noBackup (in the icon entry taglist, set for ROM entries)
    labels: '_buttonBar (button bar is treated almost like a folder)
    '_buttonBar (in tagList of icon entry)
    sequence: -1 (for Extras application)



    """

    def __init__(self, ref_newt):
	"""Create a package decoder.

	*ref_newt* -- reference to a Newton instance
	Returns    -- decoder instance

	the decoder takes a byte string containing a package, and
	activates it.  the activated packages' templates are stored in
	the heap of the specified newton instance."""

	pass


    def file_load(self, str_file):
	"""Load a package from a disc file.

	*str_file* -- file name of package
	Returns    -- nothing

	This method will load a package from a disc file into a VBO in
	to Packages soup of the default store.  It'd really only
	useful for debugging purposes, and could be removed once
	bootstrapping is complete(?).

	The package is loaded into a VBO in the soup.  After loading,
	a package must still be activated before it can be used."""

	#-- get default store
	#-- unpack package directory (to get size)
	#-- create VBO
	#-- load package into VBO
	#-- add entries to packages soup

	return


    def activate(self, pkgRef):
	"""Activate a package from a VBO.

	*pkgRef* -- pointer to a package VBO in a soup
	Returns  -- nothing

	Package activation is described in the Newton Formats document
	on page 1-3."""

	#-- obtain byte string from VBO
	#-- create app templates during string parse

	return


#############################################################################

class Package:
    """ """

    def __init__(self):
	""" """

	self._dir = None
	self._reloc = None
	self._parts = []

	self._part_offset = 0

	self._d_ptr = {}       # pointer offset to reference lookup table

	return


    def unpack(self, s, o=0):
	"""Load from a string."""

	#-- decode package directory
	self._dir = PackageDirectory()
	o = self._dir.unpack(self, s, o)
	print self._dir

	#-- decode relocation info (optional)
	if self._dir.flags & kRelocationFlag:
	    self._reloc = RelocationHeader()
	    o = self._reloc.unpack(self, s, o)

	else:
	    print "No relocation info"

	#-- set offset of part data
	self._part_offset = o

	#-- decode part data
	self._parts = []
	for idx in range(self._dir.numParts):
	    self._parts.insert(idx, Part())
	    o = self._parts[idx].unpack(self, idx, s, o)
	    
	return


    def freeze(self):
	return


    def thaw(self):
	return



#############################################################################

class PackageDirectory:

    def __init__(self):
	""" """

	self.signature = ""
	self.flags = 0
	self.version = 0
	self.copyright = None
	self.name = None
	self.size = 0
	self.creationDate = 0
	self.directorySize = 0
	self.numParts = 0
	self.parts = []
	self.varLenData = ""

	return


    def unpack(self, pkg, s, o):
	"""Unpack the PackageDirectory from a package.

	"pkg"           Package object
	"s"             byte string of package
	"o"             byte offset to be unpacked first
	Return value    byte offset to be unpacked next
	Exceptions      ???"""

	#-- unpack fixed fields
	f = ">8s L L L H H H H L L L L L L"
	hdr_len = struct.calcsize(f)

	#print "sizeof package header =", hdr_len
	sig, res1, flg, ver, copy_os, copy_len, name_os, name_len, \
	size, date, res2, res3, dirs, num = \
	struct.unpack(f, s[o:o+hdr_len])

	#-- sanity check values
	if sig not in (PACKAGE0, PACKAGE1):
	    raise BadSignature(sig)

	#-- store simple values
	self.signature = sig
	self.flags = flg
	self.version = ver
	self.copyright = ""
	self.name = ""
	self.size = size
	self.creationDate = date   #fixme: need to convert to Unix epoch
	self.directorySize = int(dirs)
	self.numParts = num

	#-- unpack part entries
	o = o + hdr_len
	for part in range(self.numParts):
	    p = PartEntry()
	    o = p.unpack(pkg, s, o)
	    self.parts.append(p)

	#-- unpack variable length values
	self.copyright = ustr2str(s[int(o+copy_os):int(o+copy_os+copy_len)])
	self.name = ustr2str(s[int(o+name_os):int(o+name_os+name_len)])

	return self.directorySize

	

    def __str__(self):

	s = "Header:\n"
	s = s + "  sig       = %s\n" % self.signature
	s = s + "  flags     = %x\n" % self.flags
	s = s + "  version   = %d\n" % self.version
	s = s + "  copy      = %s\n" % self.copyright
	s = s + "  name      = %s\n" % self.name
	s = s + "  size      = %d\n" % self.size
	s = s + "  date      = %s\n" % self.creationDate
	s = s + "  dir size  = %d\n" % self.directorySize
	s = s + "  num parts = %d\n\n" % self.numParts

	for p in self.parts:
	    s = s + "Part: \n"
	    s = s + str(p)

	return s


#############################################################################

class PartEntry:
    """ """

    def __init__(self):
	""" """

	self.offset = 0            # byte offset of part data from start
	                           # of part data section. must be a
	                           # multiple of four.
	self.size = 0              # size in bytes of part data
	self.size2 = 0             # must be the same value as size
	self.type = 0              # code indicating type of the part
	self.flags = 0
	self.info = None

	return


    def unpack(self, pkg, s, o):
	"""Unpack a PartEntry from a package.

	"pkg"           Package object
	"s"             byte string of package
	"o"             byte offset to be unpacked first
	Return value    byte offset to be unpacked next
	Exceptions      ???"""

	f = ">L L L L L L H H L"
	pe_len = struct.calcsize(f)

	ost, sz, sz2, type, res1, \
	flg, i_os, i_len, res2 = \
	struct.unpack(f, s[o : o+pe_len])

	#-- sanity check
	if sz != sz2:
	    raise BadPartSize(sz, sz2)

	self.offset = ost
	self.size = sz
	self.size2 = sz2
	self.type = type
	self.flags = flg
	self.info = None

	return (o + pe_len)


    def __str__(self):
	s = ""
	s = s + "  offset    = %d\n" % self.offset
	s = s + "  size      = %d (0x%x)\n" % (self.size, self.size)
	s = s + "  size2     = %d\n" % self.size2
	s = s + "  type      = %x\n" % self.type
	s = s + "  flags     = %x\n" % self.flags

	return s


#############################################################################

class RelocationHeader:
    def __init__(self):
	self.reserved = 0          # must be zero
	self.relocationSize = 0    # total size in bytes of relocation info
	                           # area, including the header
	self.pageSize = 0          # size in bytes of reloc page. must be 1024
	self.numEntries = 0        # num entries following header
	self.baseAddress = 0       # original base address of package


#############################################################################

class RelocationSet:
    def __init__(self):
	self.pageNumber = 0        # zero-based index of the page in the
	                           # package to which this set applies
	self.offsetCount = 0       # number of offset bytes to follow
	self.offsets = ""          # offsets of the words to be relocated.
                                   # each byte is a zero-based index
                                   # of a word in the page to be
                                   # relocated.  for example, the
                                   # offset 0x10 means to relocate a
                                   # word 0x40 bytes into the page.
        return


#############################################################################

class Part:
    """

    Parts are the basic components of Newton packages.  A package may
    contain zero or more parts; usually one.  Various part types are
    possible:

    auto  -  background (not launchable as apps)
    form  -  normal applications
    font  -  fonts
    dict  -  handwriting recognition dictionaries
    book  -  Newton books
    soup  -  read-only soups

    others?  (printer drivers?  ethernet drivers? what are Raw and
    Protocol parts?)

    All parts except for soups are a NewtonScript frame object, with
    slot references to other objects, all packaged together.  The
    conventions for what goes into the base "part frame" are not
    documented.

    """

    def __init__(self):
	self._real = None
        return

    
    def unpack(self, pkg, idx, s, o):
	"""Unpack the idx-th part for pkg from s at offset o."""

	print "Part.unpack()"
        
	flg_part = pkg._dir.parts[idx].flags

	if flg_part & kNOSPart:
	    self._real = NOSPart()
	    o = self._real.unpack(pkg, idx, s, o)

	elif flg_part & kRawPart:
	    print "RawPart: arrrggghh!!!"

	elif flg_part & 0x3 == 0:
	    print "ProtocolPart: argh!"

	else:
	    print "dunno what happened here ..."
	    sys.exit(1)

	return o


#############################################################################

class NOSPart:
    def __init__(self):
        pass
    
    def unpack(self, pkg, idx, s, o):
        
	self._part_entry  = pkg._dir.parts[idx]
	offset = int(o + self._part_entry.offset)
	print "unpack NOS part@%d, offset=%d" % (o, offset)

	#-- dumb hex dump
## 	for i in range(self._part_entry.size / 4):
## 	    print "%04x : " % (i*4),
## 	    for b in s[offset+(4*i):offset+(4*i)+4]:
## 		print "%4s " % (hex(ord(b))),
## 	    print
## 	print


	#-- unpack initial array object
	print "Unpacking the initial array ..."
	self._partArray = Array()
	self._partArray.unpack(pkg, s, offset)

        print self._partArray
        
	#-- unpack part frame
	#print "Unpacking the part frame ..."
	#ptr = self._partArray[0]

	#self._partFrame = Frame()
	#self._partFrame.unpack(pkg, s, ptr.index())

	#-- unpack templates, creating frames
	#print self._partFrame["theForm"]

	return o




#############################################################################

def ustr2str(s):
    """Remove high bytes from a unicode string."""

    o = ""
    f = 0
    for b in s:
	if f:
	    f = 0
	    if b == "\000":
		b = " "
	    o = o + b
	else:
	    f = 1

    return o


#############################################################################

if __name__ == "__main__":

    #-- decode and load a package file ;-)

    #-- read file data
    f = open(sys.argv[1])
    s = f.read()
    f.close()


    p = Package()
    p.unpack(s)

    print
    print p._parts[0]._real._partArray[0].target()["theForm"].target()["stepChildren"].target()[0].target()["buttonClickScript"]

#############################################################################
