#! /usr/bin/env python1.5
#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/CVS/gnuton/lib/GnutOS/DeskPadDisplayDevice.py,v $
# Version:     $RCSfile: DeskPadDisplayDevice.py,v $ $Revision: 1.2 $
# Copyright:   (C) 1998-2000, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""

"""

#############################################################################

import Tkinter

from   GnutOS.DeviceDriver             import DeviceDriver
from   GnutOS.Device                   import Device


#############################################################################

class DeskPadDisplayDriver(DeviceDriver):
    """

    Driver code for hardware devices.

    """

    def __init__(self, hwMgr):
	self._mgr = hwMgr

    def DeviceType(self):
	"""Return an identifier for the device type."""
	return "display"

    def Name(self):
	"""Return the unique signature for this driver."""
	return "DPDisplay"

    def ParentType(self):
	return self._driver.type()

    def IsShareable(self):
	return self._driver.shareable()

    def NewDevice(self, t_param):
	"""Create a device instance."""
	return Device(self, t_param)


#############################################################################

class DeskPadDisplayDevice(Device):
    def __init__(self, ref_drv, t_param):
	self._driver = ref_drv
	self._param = t_param

	self._canvas = self._driver._mgr._gnut._dev._screen  # phew! ;-)
	self._width  = int(self._canvas.configure("width")[4])
	self._heigth = int(self._canvas.configure("height")[4])

	return


    def DriverName(self):
	return "DPDisplay"

    def DeviceType(self):
	return self._driver.type()

    def ParentType(self):
	return self._driver.parent()

    def IsShareable(self):
	return self._driver.shareable()

    def Reserve(self):
	pass

    def Release(self, uid):
	pass


    def Canvas(self):
	"""Return the canvas handle."""
	return self._canvas


    def Update(self):
	self._driver._mgr._gnut._dev.tk.update()  # phew! ;-)
	return


    def getWidth(self):
	"""Return the width of the screen in pixels."""
	return self._width


    def getHeight(self):
	"""Return the width of the screen in pixels."""
	return self._height



    #
    #   primitive graphical view classes
    #

    def plView(self, template):
	"""The most primitive view class."""

	pass

    def plPictureView(self, template):
	pass

    def plEditView(self, template):
	pass

    def plParagraphView(self, template):
	pass

    def plPolygonView(self, template):
	pass

    def plKeyboardView(self, template):
	pass

    def plMonthView(self, template):
	pass

    def plRemoteView(self, template):
	pass

    def plPickView(self, template):
	pass

    def plGaugeView(self, template):
	pass

    def plOutline(self, template):
	pass


    #
    #   drawing methods for display devices
    #

    def DrawPixel(colour, x, y):
	"""Draw pixel at specified coordinates, in specified colour."""

	pass


    def DrawLine(colour, width, style, capStyle, *args):
	"""Draw a line joining the specified points."""

	pass


    def DrawRect(colour, borderWidth, borderColour, x1, y1, x2, y2):
	pass


    def DrawRoundRect(colour, borderWidth, borderColour, x1, y1, x2, y2):
	pass


    def DrawArc(colour, borderWidth, borderColour, extent, xc, yc, x1, y1):
	pass


    def DrawPixmap(pixMap, x, y):
	pass



#############################################################################

class DPView():
    """DPView

    Primitive view class for DeskPad device, using Tkinter for all
    graphics.  This causes some limitations, notably in the
    viewEffects and TransferMode settings, but it'll do for now.

    Instances of this class are registered with the ViewManager, which
    assigns them a unique identifier.  This identifier is then used in
    the "viewCObject" slot in template frames.

    This class is specialised by derived classes to implement
    viewClasses other than clView.

    """


    def __init__(self, ref_vm, template, ref_parent):
	"""Create a new clView viewCObject using the DeskPad."""

	self._display = ref_vm._display

	#-- find parent view (only root doesn't have one)
	if template.has_key("_parent"):
	    parent = template["_parent"]
	else:
	    parent = None

	#-- check view justification
	if template.has_key("viewJustify"):
	    vj = template["viewJustify"]
	else:
	    vj = 0

	#-- get view's parent
	if not parent:  # ie. root view
	    parent_bounds = {"left":   0,
			     "top":    0,
			     "right":  self._display.getWidth(),
			     "bottom": self._display.getHeight()}

	else:
	    parent_view = parent["viewCObject"]
	    parent_bounds = parent_view.getBounds()

	#-- get view's sibling
	sib = None   #fixme: need to get this ...

	#-- determine view horizontal bounds (using justification also)
	rel_bounds = template["viewBounds"]
	sib_bounds = sibling["viewCObject"].getBounds()

	if vj & vjParentHMask == vjParentLeftH:
	    left  = parent_bounds["left"] + rel_bounds["left"]
	    right = parent_bounds["left"] + rel_bounds["right"]

	elif vj & vjParentHMask == vjParentCenterH:
	    width = rel_bounds["right"] - rel_bounds["left"]
	    parent_width = parent_bounds["right"] - parent_bounds["left"]
	    parent_centre = (parent_width / 2) + parent_bounds["left"]

	    if rel_bounds["left"] = 0:
		left = parent_centre - (width / 2)
		right = left + width
	    else:
		left = parent_centre + rel_bounds["left"]
		right = left + width   #fixme: not sure about this ...

	elif vj & vjParentHMask == vjParentRightH:
	    left  = parent_bounds["right"] + rel_bounds["left"]
	    right = parent_bounds["right"] + rel_bounds["right"]

	elif vj & vjParentHMask == vjParentFullH:
	    left  = parent_bounds["left"] + rel_bounds["left"]
	    right = parent_bounds["right"] + rel_bounds["right"]

	elif vj & vjSiblingHMask == vjSiblingLeftH:
	    left  = sib_bounds["left"] + rel_bounds["left"]
	    right = sib_bounds["left"] + rel_bounds["right"]

	elif vj & vjSiblingHMask == vjSiblingCenterH:
	    pass

	elif vj & vjSiblingHMask == vjSiblingRightH:
	    left  = sib_bounds["right"] + rel_bounds["left"]
	    right = sib_bounds["right"] + rel_bounds["right"]

	elif vj & vjSiblingHMask == vjSiblingFullH:
	    left  = sib_bounds["left"] + rel_bounds["left"]
	    right = sib_bounds["right"] + rel_bounds["right"]

	else:
	    print "Arrrrrggghhh.  Bad view bounds"
	    sys.exit(1)


	#-- determine view vertical bounds (using jsutification also)

	#-- determine fill colour

	#-- determine fill pattern (if any)

	#-- draw view
	border  = c.create_rectangle(x1-5,y1-5,x2+5,y2+5,
				     outline="gray50",
				     fill="gray70",
				     width=10)

	c.tag_bind(tag, "<ButtonPress-1>", self._buttonPress)
	c.tag_bind(tag, "<Motion>", self._motion)
	c.tag_bind(tag, "<ButtonRelease-1>", self._buttonRelease)


	#-- determine frame offset

	#-- determine frame style

	#-- determine frame pattern (if any)
	
	#-- draw frame
	outline = c.create_line     (cx/2,  y1-10,
				     x2,    y1-10,
				     x2,    y1-10,
				     x2+10, y1-10,
				     x2+10, y1,
				     x2+10, y1,
				     x2+10, y2,
				     x2+10, y2,
				     x2+10, y2+10,
				     x2,    y2+10,
				     x2,    y2+10,
				     x1,    y2+10,
				     x1,    y2+10,
				     x1-10, y2+10,
				     x1-10, y2,
				     x1-10, y2,
				     x1-10, y1,
				     x1-10, y1,
				     x1-10, y1-10,
				     x1,    y1-10,
				     x1,    y1-10,
				     cx/2,  y1-10,
				     fill="black", 
				     smooth=1,
				     splinesteps=4,
				     width=4)

	#-- draw "dagger" (if required)
	if vf == vfFrameDagger:
	    #-- allocate tag
	    tag = "foo"   #fixme: need a unique tag to be stored in view

	    handle  = c.create_polygon  (cx/2,    y1-10,
					 cx/2-8,  y1-10,
					 cx/2,    y1,
					 cx/2+8,  y1-10,
					 cx/2,    y1-10,
					 fill="gray70",
					 outline="black",
					 smooth=1,
					 splinesteps=6,
					 width=4,
					 tag="handle")
	    t = self._template
	    c.tag_bind(tag, "<ButtonPress-1>", self._startDrag)
	    c.tag_bind(tag, "<Motion>", self._moveDrag)
	    c.tag_bind(tag, "<ButtonRelease-1>", self._stopDrag)

	return


    def getBounds(self):
	return self._bounds


    #
    #   event handling methods
    #

    def _buttonPress(self, e):
	print "_buttonPress"

    def _buttonRelease(self, e):
	print "_buttonRelease"

    def _motion(self, e):
	print "_motion"

    def _startDrag(self, e):
	print "_startDrag"

    def _moveDrag(self, e):
	print "_moveDrag"

    def _stopDrag(self, e):
	print "_stopDrag"


#############################################################################
